﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LINQ_to_Objects
{
    public partial class Form1 : Form
    {
        //źródło danych
        List<Osoba> listaOsob = new List<Osoba> 
        { 
            new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 7272024, Wiek = 38 }, 
            new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 7272020, Wiek = 39 },
            new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", NumerTelefonu = 7272021, Wiek = 10 }, 
            new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", NumerTelefonu = 7272022, Wiek = 5 } 
        };

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //zapytanie
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select osoba;
            List<Osoba> podlista = listaOsobPelnoletnich.ToList<Osoba>();

            //prezentacja danych
            string s = "Lista osób pełnoletnich:\n";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);

            //proste obliczenia za pomocą rozszerzeń IEnumerable<T>
            MessageBox.Show("Wiek najstarszej osoby: " + listaOsobPelnoletnich.Max(osoba => osoba.Wiek));
            MessageBox.Show("Średni wiek osób pełnoletnich: " + listaOsobPelnoletnich.Average(osoba => osoba.Wiek));
            MessageBox.Show("Suma lat osób pełnoletnich: " + listaOsobPelnoletnich.Sum(osoba => osoba.Wiek));

            //wybór elementu
            var najstarszaOsoba = listaOsobPelnoletnich.Single(osoba1 => (osoba1.Wiek == listaOsobPelnoletnich.Max(osoba => osoba.Wiek)));
            MessageBox.Show("Najstarsza osoba: " + najstarszaOsoba.Imię + " " + najstarszaOsoba.Nazwisko + " (" + najstarszaOsoba.Wiek + ")");

            //weryfikowanie danych
            bool czySpełniaWarunek = listaOsobPelnoletnich.All(osoba => (osoba.Wiek > 18));
            bool czyZawieraPelnoletnią = listaOsob.Any(osoba => (osoba.Wiek > 18));
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var grupyOsobOTymSamymNazwisku = from osoba in listaOsob
                                             group osoba by osoba.Nazwisko into grupa
                                             select grupa;
            string s = "Lista osób pogrupowanych nazwiskami:\n\n";
            foreach (var grupa in grupyOsobOTymSamymNazwisku)
            {
                s += "Grupa osób o nazwisku " + grupa.Key + "\n";
                foreach (Osoba osoba in grupa)
                    s += osoba.Imię + " " + osoba.Nazwisko + "\n";
                s += "\n";
            }
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            var listaKobiet = from osoba in listaOsob
                              where osoba.Imię.EndsWith("a")
                              select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet);
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet).Distinct();
            var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Union(listaKobiet);            

            string s = "Lista osób pełnoletnich lub kobiet:\n";
            foreach (var osoba in listaPelnoletnich_I_Kobiet) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);

            var listaKobietPelnoletnich = listaOsobPelnoletnich.Intersect(listaKobiet);
            var listaPelnoletnichNiekobiet = listaOsobPelnoletnich.Except(listaKobiet);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            var listaTelefonów = from osoba in listaOsob
                                 select new { osoba.Id, osoba.NumerTelefonu };
            var listaPersonaliów = from osoba in listaOsob
                                   select new { osoba.Id, osoba.Imię, osoba.Nazwisko };

            var listaPersonaliówZTelefonami = from telefon in listaTelefonów
                                              join personalia in listaPersonaliów
                                              on telefon.Id equals personalia.Id
                                              select new
                                              {
                                                  telefon.Id,
                                                  personalia.Imię,
                                                  personalia.Nazwisko,
                                                  telefon.NumerTelefonu
                                              };

            string s = "Lista osób:\n";
            foreach (var osoba in listaPersonaliówZTelefonami) s += osoba.Imię + " " + osoba.Nazwisko + ", tel. " + osoba.NumerTelefonu + "\n";
            MessageBox.Show(s);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select osoba;

            /*
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select new Osoba
                                        {
                                            Id = osoba.Id,
                                            Imię = osoba.Imię,
                                            Nazwisko = osoba.Nazwisko,
                                            NumerTelefonu = osoba.NumerTelefonu,
                                            Wiek = osoba.Wiek
                                        };
            */

            Osoba pierwszyNaLiscie = listaOsobPelnoletnich.First<Osoba>();
            pierwszyNaLiscie.Imię = "Jan";
            pierwszyNaLiscie.Nazwisko = "Kowalski";
            pierwszyNaLiscie.Wiek = 24;

            string s = "Lista osób pełnoletnich:\n";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
        }
    }

    class Osoba
    {
        public int Id;
        public string Imię, Nazwisko;
        public int NumerTelefonu;
        public int Wiek;
    }
}
